﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using ThinkGeo.MapSuite.DesktopEdition;
using ThinkGeo.MapSuite.Core;

namespace Post5988
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }        

        private void Form1_Load(object sender, EventArgs e)
        {
            winformsMap1.MapUnit = GeographyUnit.Meter;
            winformsMap1.BackgroundOverlay.BackgroundBrush = new GeoSolidBrush(GeoColor.GeographicColors.ShallowOcean);

            string utmProjectionString = Proj4Projection.GetEpsgParametersString(4326);
            string googleProjectionString = Proj4Projection.GetGoogleMapParametersString();
            Proj4Projection googleProjection = new Proj4Projection(utmProjectionString, googleProjectionString);

            GoogleMapsOverlay googleOverlay = new GoogleMapsOverlay();
            googleOverlay.CacheDirectory = @"C:\GoogleCache";
            winformsMap1.Overlays.Add("GoogleOverlay", googleOverlay);

            string connectString = @"Data Source=SQL2008SERVER\TGSQLSERVER;Initial Catalog=InternalDB;User ID=sa;Password=akeypmon1";
            
            MsSql2008FeatureLayer sql2008Layer = new MsSql2008FeatureLayer(connectString, "cntry02", "ID");            
            sql2008Layer.FeatureSource.Projection = googleProjection;
            sql2008Layer.ZoomLevelSet.ZoomLevel01.DefaultAreaStyle = AreaStyles.Country2;//new AreaStyle(new GeoPen(GeoColor.SimpleColors.Blue, 5));
            sql2008Layer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

            MsSql2008FeatureLayer sql2008RoadLayer = new MsSql2008FeatureLayer(connectString, "ALlkaA40", "ID");
            sql2008RoadLayer.FeatureSource.Projection = googleProjection;
            sql2008RoadLayer.ZoomLevelSet.ZoomLevel01.DefaultLineStyle = LineStyles.Highway1;
            sql2008RoadLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

            LayerOverlay staticLayerOverlay = new LayerOverlay();
            staticLayerOverlay.Layers.Add("Sql2008Layer", sql2008Layer);
            staticLayerOverlay.Layers.Add("Sql2008RoadLayer", sql2008RoadLayer);
            winformsMap1.Overlays.Add(staticLayerOverlay);

            InMemoryFeatureLayer firstInMemoryFeatureLayer = new InMemoryFeatureLayer();
            firstInMemoryFeatureLayer.FeatureSource.Projection = googleProjection;
            firstInMemoryFeatureLayer.InternalFeatures.Add(new Feature(new PointShape(-10, 10)));
            firstInMemoryFeatureLayer.InternalFeatures.Add(new Feature(new PointShape(-11, 10)));
            firstInMemoryFeatureLayer.InternalFeatures.Add(new Feature(new PointShape(-12, 10)));
            firstInMemoryFeatureLayer.ZoomLevelSet.ZoomLevel01.DefaultPointStyle = PointStyles.City1;
            firstInMemoryFeatureLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

            InMemoryFeatureLayer secondInMemoryFeatureLayer = new InMemoryFeatureLayer();
            secondInMemoryFeatureLayer.InternalFeatures.Add(new Feature(new EllipseShape(new PointShape(-10, 10), 1)));

            secondInMemoryFeatureLayer.ZoomLevelSet.ZoomLevel01.DefaultAreaStyle = new AreaStyle(new GeoPen(GeoColor.SimpleColors.Blue, 5));
            secondInMemoryFeatureLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;
            secondInMemoryFeatureLayer.FeatureSource.Projection = googleProjection;

            LayerOverlay inMemoryLayerOverlay = new LayerOverlay();
            inMemoryLayerOverlay.Layers.Add(firstInMemoryFeatureLayer);
            inMemoryLayerOverlay.Layers.Add(secondInMemoryFeatureLayer);
            winformsMap1.Overlays.Add(inMemoryLayerOverlay);

            winformsMap1.CurrentExtent = new RectangleShape(-2199858.29278418,1944322.42159175,-288105.747556643,303584.604997996);//sql2008Layer.GetBoundingBox();
            winformsMap1.Refresh();
        }
    }
}
