using System;
using System.IO;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using ThinkGeo.Core;
using ThinkGeo.UI.Wpf;

namespace Post12316Repro.App;

public partial class MainWindow : Window
{
	public MainWindow()
	{
		InitializeComponent();
	}

	private async void MapView_Loaded(object sender, RoutedEventArgs e)
	{
		MapView.MapUnit = GeographyUnit.Meter;

		var openStreetMapOverlay = new OpenStreetMapOverlay("Post12316Repro");
		MapView.Overlays.Add(openStreetMapOverlay);

		var rasterFilePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data", "input-9x11.png");

		if (!File.Exists(rasterFilePath))
		{
			GenerateInputRasterFile(rasterFilePath);
		}

		var overlay = new LayerOverlay
		{
			TileType = TileType.SingleTile,
		};
		MapView.Overlays.Add(overlay);

		RectangleShape rasterExtent = new RectangleShape(-10_782_500, 3_917_500, -10_773_500, 3_906_500);
		var rasterLayer = new SkiaRasterLayer(rasterFilePath, rasterExtent);
		overlay.Layers.Add(rasterLayer);

		MapView.CurrentExtent = rasterExtent;
		var initialScale = MapUtil.GetScale(MapView.MapUnit, rasterExtent, MapView.MapWidth, MapView.MapHeight);
		MapView.CurrentScale = initialScale * 2.8;

		await MapView.RefreshAsync();
	}


	private static void GenerateInputRasterFile(string outputPath)
	{
		Directory.CreateDirectory(Path.GetDirectoryName(outputPath)!);

		const int width = 9;
		const int height = 11;
		var pixels = new byte[width * height * 4];

		var pattern = new[]
		{
			".........",
			".112223..",
			".112223..",
			".11..23..",
			".444556..",
			".444556..",
			".44..56..",
			"..777888.",
			"..777888.",
			"..77..88.",
			"........."
		};

		for (var y = 0; y < height; y++)
		{
			for (var x = 0; x < width; x++)
			{
				var symbol = pattern[y][x];
				var color = GetCellColor(symbol);

				var pixelIndex = ((y * width) + x) * 4;
				pixels[pixelIndex] = color.B;
				pixels[pixelIndex + 1] = color.G;
				pixels[pixelIndex + 2] = color.R;
				pixels[pixelIndex + 3] = color.A;
			}
		}

		var bitmap = BitmapSource.Create(width, height, 96, 96, PixelFormats.Bgra32, null, pixels, width * 4);
		var encoder = new PngBitmapEncoder();
		encoder.Frames.Add(BitmapFrame.Create(bitmap));

		using var stream = new FileStream(outputPath, FileMode.Create, FileAccess.Write, FileShare.None);
		encoder.Save(stream);
	}

	private static (byte R, byte G, byte B, byte A) GetCellColor(char symbol)
	{
		return symbol switch
		{
			'1' => (255, 40, 30, 210),
			'2' => (255, 134, 31, 210),
			'3' => (240, 216, 27, 210),
			'4' => (124, 219, 70, 210),
			'5' => (23, 191, 230, 210),
			'6' => (37, 110, 255, 210),
			'7' => (20, 205, 180, 210),
			'8' => (12, 88, 160, 210),
			_ => (0, 0, 0, 0)
		};
	}
}
