﻿Imports ThinkGeo.Core

<Serializable()>
Public Class CustomLabelingCandidate
  Inherits LabelingCandidate
  Public Property LabelingId As Integer
  Public Sub New()
    MyBase.New()
  End Sub
  Public Sub New(oLabelingCandidate As LabelingCandidate, iLabelingId As Integer)
    MyBase.New
    With oLabelingCandidate
      CenterPointInScreenCoordinate = .CenterPointInScreenCoordinate
      For Each oInfo As LabelInformation In .LabelInformation
        Me.LabelInformation.Add(oInfo)
      Next
      OriginalText = .OriginalText
      ScreenArea = .ScreenArea
    End With
    LabelingId = iLabelingId
  End Sub
  Public Sub New(oLabelingCandidate As LabelingCandidate, iLabelingId As Integer, oWorldVertex As Vertex, oCanvas As GeoCanvas)
    MyBase.New

    With oLabelingCandidate
      'Dim o As ScreenPointF = ExtentHelper.ToScreenCoordinate(oCanvas.CurrentWorldExtent, oWorldVertex.X, oWorldVertex.Y, oCanvas.Width, oCanvas.Height)
      Dim o As ScreenPointF = MapUtil.ToScreenCoordinate(oCanvas.CurrentWorldExtent, oWorldVertex.X, oWorldVertex.Y, oCanvas.Width, oCanvas.Height)
      Dim oPoint As PointShape = New PointShape(o.X, o.Y)
      CenterPointInScreenCoordinate = o
      For Each oInfo As LabelInformation In .LabelInformation
        oInfo.PositionInScreenCoordinates = o
        LabelInformation.Add(oInfo)
      Next oinfo
      OriginalText = .OriginalText
      ScreenArea = .ScreenArea
    End With
    LabelingId = iLabelingId
  End Sub

End Class
