﻿Imports System.Collections.ObjectModel
Imports NetTopologySuite.Operation
Imports ThinkGeo.Core
Imports ThinkGeo.UI.WinForms
Public Class Form1
  Public WithEvents MainMap As CustomMapView
  Private WithEvents mExtentOverlay As ExtentInteractiveOverlay
  Private moShapefile As ShapeFileFeatureLayer
  Private moOverlay As New LayerOverlay
  Private Async Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
    MainMap = New CustomMapView With {
      .Dock = DockStyle.Fill
    }

    Controls.Add(MainMap)
    MainMap.BringToFront()
    mExtentOverlay = MainMap.ExtentOverlay
    MainMap.MapUnit = GeographyUnit.Meter
    MainMap.ExtentOverlay.PanMode = MapPanMode.StandardPanning
    mAddShapefile()
    'Await mAddWmtsLayer()

    Await MainMap.refreshasync
  End Sub

  Public Sub New()
    InitializeComponent()

    ThinkGeoDebugger.LogType = ThinkGeoLogType.All
    ThinkGeoDebugger.LogLevel = ThinkGeoLogLevel.Error
  End Sub
  Private Sub mAddShapefile()
    Dim sShapefilepath As String = "..\..\Data\States_Albers.shp"
    moShapefile = New ShapeFileFeatureLayer(sShapefilepath, IO.FileAccess.ReadWrite)

        Dim oAreaStyle As AreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColors.Transparent, GeoColors.Red, 3)
        Dim oGeoFont As New GeoFont("Calibri", 14, DrawingFontStyles.Regular)
    Dim oText As New CustomTextStyle_2("", oGeoFont, GeoBrushes.Black, MainMap, CustomTextStyle_2.EnumTextSymbolType.Polygon) With {.TextContent = "State Name = {StateName}"}
    'Dim oText As New TextStyle("[StateName]", oGeoFont, GeoBrushes.Black)

    moShapefile.ZoomLevelSet.ZoomLevel01.DefaultAreaStyle = oAreaStyle
    moShapefile.ZoomLevelSet.ZoomLevel01.DefaultTextStyle = oText
    moShapefile.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20

    moOverlay = New LayerOverlay With {.Name = "Layers", .TileType = TileType.SingleTile}
    MainMap.Overlays.Add("Layers", moOverlay)

    moShapefile.Open()

    'Dim oFeatures = moShapefile.QueryTools.GetAllFeatures(ReturningColumnsType.AllColumns)


    Dim oConverter As New GdalProjectionConverter(102003, 3857)

    'Dim oConverter = New ProjectionConverter(102003, 4326)
    oConverter.Open()
    moShapefile.FeatureSource.ProjectionConverter = oConverter

    MainMap.MapUnit = GeographyUnit.Meter
    moOverlay.Layers.Add(moShapefile)

  End Sub


End Class
