﻿using System.Windows;
using ThinkGeo.Core;
using ThinkGeo.UI.Wpf;

namespace ArcGisServerLayerSample
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private async void mapView_Loaded(object sender, RoutedEventArgs e)
        {
            mapView.MapUnit = GeographyUnit.Meter;

            var url = "https://maps.ffm.vic.gov.au/arcgis/rest/services/ocr_intel_services/MapServer/0/query";

            var arcgisLayer = new ArcGisServerRestVectorAsyncLayer(url);
            arcgisLayer.OutSR = "3111";

            await arcgisLayer.OpenAsync();

            arcgisLayer.ZoomLevelSet.ZoomLevel01.DefaultAreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColors.Red);
            arcgisLayer.ZoomLevelSet.ZoomLevel01.DefaultLineStyle = LineStyle.CreateSimpleLineStyle(GeoColors.Blue, 2, false);
            arcgisLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

            var layerOverlay = new LayerOverlay();
            layerOverlay.Layers.Add(arcgisLayer);

            mapView.Overlays.Add(layerOverlay);

            mapView.CurrentExtent = arcgisLayer.GetBoundingBox();

            await mapView.RefreshAsync();

        }
    }
}