﻿using SkiaSharp;
using System.Linq;

namespace MapTestBlazor2.Extensions
{


    public static class SkBitmapExtensions
    {
        /// <summary>
        /// Makes all pixels of a specific color in an SKBitmap transparent.
        /// </summary>
        /// <param name="bitmap">The source bitmap.</param>
        /// <param name="colorToMakeTransparent">The color to replace with transparency.</param>
        public static void MakeColorTransparent(this SKBitmap bitmap, SKColor colorToMakeTransparent)
        {
            // Ensure the bitmap supports an alpha channel (e.g., Format32bppArgb equivalent)
            if (bitmap.ColorType != SKColorType.Bgra8888 && bitmap.ColorType != SKColorType.Rgba8888)
            {
                // You might need to convert the bitmap format first if it doesn't support alpha
                // For simplicity, this example assumes a compatible format.
                // A conversion could involve creating a new bitmap with the correct info and drawing the old one onto it.
                // For example:
                // SKImageInfo info = new SKImageInfo(bitmap.Width, bitmap.Height, SKColorType.Bgra8888, SKAlphaType.Premul);
                // SKBitmap newBitmap = bitmap.CopyTo(info); // This returns a new bitmap in the desired format
                // bitmap = newBitmap; // Replace the old one (careful with object references)
            }

            int pixelCount = bitmap.Width * bitmap.Height;
            SKColor[] pixels = bitmap.Pixels;
            SKColor transparent = SKColors.Transparent; // SKColors.Transparent is #00FFFFFF

            for (int i = 0; i < pixelCount; i++)
            {
                if (pixels[i] == colorToMakeTransparent)
                {
                    pixels[i] = transparent;
                }
            }

            bitmap.Pixels = pixels; // Re-set the pixels property to update the bitmap
        }
    }
}
