﻿using ThinkGeo.Core;

namespace HowDoISample
{
    public class MyMapLayer : WebRasterXyzTileAsyncLayer
    {

        public MyMapLayer() : base(256, GeographyUnit.Meter, MapConfig.VicGridFullExtent)
        {
            this.UpperScale = 10000000;
            this.LowerScale = 2000;
            this.Projection = new Projection(3111);


            // Clear default matrices and add custom ones
            TileMatrixSet.TileMatrices.Clear();

            foreach (var zoomDetail in MapConfig.MapZoomingDetails)
            {
                // Calculate bounding box for this zoom level
                var boundingBox = CalculateTileBoundingBox(zoomDetail.Resolution);

                TileMatrixSet.TileMatrices.Add(new TileMatrix(
                    zoomDetail.Scale,
                    MapConfig.TileSize,
                    MapConfig.TileSize,
                    boundingBox,
                    GeographyUnit.Meter
                ));
            }
        }
        private RectangleShape CalculateTileBoundingBox(double resolution)
        {
            // Calculate tile size in meters at this resolution
            double tileSizeMeters = MapConfig.TileSize * resolution;

            var fullExtent = MapConfig.VicGridFullExtent;
            double originX = -3.49328E7;
            double originY = 5.71192E7;
            // Calculate number of tiles needed to cover the extent
            var cols = Math.Ceiling((fullExtent.UpperRightPoint.X - originX) / tileSizeMeters);
            var rows = Math.Ceiling((originY - fullExtent.LowerLeftPoint.Y) / tileSizeMeters);

            // Calculate world bounds
            double worldLeft = originX;
            double worldTop = originY;
            double worldRight = worldLeft + (cols * tileSizeMeters);
            double worldBottom = worldTop - (rows * tileSizeMeters);

            return new RectangleShape(worldLeft, worldTop, worldRight, worldBottom);
        }

        protected override Task<RasterTile> GetTileAsyncCore(int zoomLevel, long x, long y, float resolutionFactor, CancellationToken cancellationToken)
        {
            return base.GetTileAsyncCore(zoomLevel, x, y, resolutionFactor, cancellationToken);
        }
        protected override Task<string> GetImageUriAsyncCore(int zoomLevel, long x, long y, float resolutionFactor)
        {
            // The generated y and x is not correct all the time...Have to go through below method to calculate the X Y in server
            //var p = CalculateServerTileXY(zoomLevel, x, y);
            string url = $"https://corp-gis.mapshare.vic.gov.au/arcgis/rest/services/Basemap/MapscapeVicGridColour/MapServer/tile/{zoomLevel}/{y}/{x}";
            return Task.FromResult(url);
        }

       

    }
}
