﻿using MauiApp1;
using Newtonsoft.Json;
using Tarnook.Mobile.Core.Extensions;
using ThinkGeo.Core;
using ThinkGeo.UI.Maui;

namespace HowDoISample.MapNavigation;

public partial class NavigationP : ContentPage
{
    private bool _initialized;
    // This locaiton suppose to be https://www.google.com/maps/place/37%C2%B049'43.2%22S+144%C2%B058'46.2%22E/@-37.8286667,144.9795,17z/data=!3m1!4b1!4m4!3m3!8m2!3d-37.8286667!4d144.9795?entry=ttu&g_ep=EgoyMDI1MTIwNy4wIKXMDSoKLDEwMDc5MjA2OUgBUAM%3D
    double lat = -37.8286667;
    double lon = 144.9795;

    public NavigationP()
    {
        InitializeComponent();
    }


    private async void MapLayer_OnSizeChanged(object sender, EventArgs e)
    {
        if (_initialized)
            return;
        _initialized = true;
        mapView.MapUnit = GeographyUnit.Meter;

        var overlay = new LayerOverlay();
              mapView.Overlays.Add(overlay);
        //var wmtsLayer = new MyWmtsLayer();
        //await wmtsLayer.OpenAsync();
        //overlay.Layers.Add(wmtsLayer);
        // How to implement the same like WmtsLayer ???
        var myLayer = new MyMapLayer();
        overlay.Layers.Add(myLayer);


        var point = new PointShape(144.9794901, -37.828667);
        var projectedPoint = ProjectionConverter.Convert(4326, 3111, point);
        var locationLayer = new InMemoryFeatureLayer();
        locationLayer.InternalFeatures.Add(new Feature(projectedPoint));
        locationLayer.ZoomLevelSet.ZoomLevel01.DefaultPointStyle =
        PointStyle.CreateSimplePointStyle(PointSymbolType.Circle, GeoColors.Red, 10);
        locationLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;
        overlay.Layers.Add(locationLayer);

        mapView.CenterPoint = projectedPoint;
        mapView.MapScale = MapConfig.MapZoomingDetails[10].Scale;
        await mapView.RefreshAsync();
    }

 


   
}