﻿using System.Text;
using ThinkGeo.Core;

namespace Tarnook.Mobile.Core.Extensions
{
    public static class MappingExtensions
    {
        private static ProjectionConverter? _converter;


        private static ProjectionConverter GetConverter()
        {
            if (_converter == null)
            {
                _converter = new ProjectionConverter(
                    "+proj=lcc +lat_0=-37 +lon_0=145 +lat_1=-36 +lat_2=-38 +x_0=2500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs +type=crs",
                    Projection.GetDecimalDegreesProjString()
                    );
                _converter.Open();
            }
            else if (!_converter.IsOpen)
            {
                _converter.Open();
            }
            return _converter;
        }
  
  
        public static ThinkGeo.Core.Feature ConvertLatLonToMeters(this ThinkGeo.Core.Feature feature)
        {
            var converter = GetConverter();
            var projectedFeature = converter.ConvertToInternalProjection(feature);
            return projectedFeature;
        }


        public static PointShape ConvertLatLonToMeters(double latitude, double longitude, bool shouldCloseConverter = false)
        {
            try
            {
                var converter = GetConverter();
                var point = new PointShape(longitude, latitude);
                var projectedPoint = converter.ConvertToInternalProjection(point);
                return projectedPoint as PointShape;
            }
            catch(Exception ex)
            {
                return null;
            }
            
        }

        public static PointShape ConvertMetersToLatLong(this PointShape point)
        {
            var converter = GetConverter();
            var projectedPoint = converter.ConvertToExternalProjection(point);
            return projectedPoint as PointShape;
        }

        public static RectangleShape ConvertMetersToLatLong(this RectangleShape extent)
        {
            var converter = GetConverter();
            var projectedPoint = converter.ConvertToExternalProjection(extent);
            return projectedPoint;
        }

        public static double CalculateDistanceBetweenCoordinates(double fromLatitude, double fromLongitude, double toLatitude, double toLongitude)
        {
            double x = 69.1 * (toLatitude - fromLatitude);
            double y = 69.1 * (toLongitude - fromLongitude) * Math.Cos(fromLatitude / 57.3);

            //Convert to KM by multiplying 1.609344
            return (Math.Sqrt(x * x + y * y) * 1.609344);
        }

    

        public static double GetRandomNumber(int minimum, int maximum)
        {
            Random random = new Random();
            return random.NextDouble() * (maximum - minimum) + minimum;

            // return random.Next(minimum, maximum) + random.NextDouble();
        }

        public static RectangleShape ConvertLatLonToMeters(this RectangleShape rectangle)
        {
            var converter = GetConverter();
            var projectedFeature = converter.ConvertToInternalProjection(rectangle);
            return projectedFeature;
        }



        public static string GetLineString(this List<PointShape> points)
        {
            var polyBuilder = new StringBuilder();
            polyBuilder.Append("MULTILINESTRING((");

            for (int i = 0; i < points.Count; i++)
            {
                var point = points[i];
                polyBuilder.Append(point.X);
                polyBuilder.Append(' ');
                polyBuilder.Append(point.Y);
                if (i < points.Count - 1)
                    polyBuilder.Append(',');
            }
            polyBuilder.Append("))");
            var poly = polyBuilder.ToString();
            return poly;
        }

        public static string GetPolygonString(this List<PointShape> points)
        {
            var polyBuilder = new StringBuilder();
            polyBuilder.Append("POLYGON((");

            for (int i = 0; i < points.Count; i++)
            {
                var point = points[i];
                polyBuilder.Append(point.X);
                polyBuilder.Append(' ');
                polyBuilder.Append(point.Y);
                if (i < points.Count - 1)
                    polyBuilder.Append(',');
            }
            polyBuilder.Append("))");
            var poly = polyBuilder.ToString();
            return poly;
        }

      

       

       

    }
}
