﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using ThinkGeo.Core;
using ThinkGeo.UI.Maui;

namespace MauiApp1
{
    public class MyWmtsLayer : WmtsAsyncLayer
    {
        public MyWmtsLayer() : base(new Uri("https://corp-gis.mapshare.vic.gov.au/arcgis/rest/services/Basemap/MapscapeVicGridColour/MapServer/WMTS/1.0.0/WMTSCapabilities.xml"))
        {
            this.HttpMessageHandler = new TarnookWmtsCacheHandler(FileSystem.CacheDirectory, new HttpClientHandler() { AutomaticDecompression = DecompressionMethods.GZip | DecompressionMethods.Deflate });

            ActiveLayerName = "mapscape_gda2020";
            ActiveStyleName = "default";
            OutputFormat = "image/png";
            TileMatrixSetName = "default028mm";
        }

        protected override Task<RasterTile> GetTileAsyncCore(int zoomLevel, long x, long y, float resolutionFactor, CancellationToken cancellationToken)
        {
            return base.GetTileAsyncCore(zoomLevel, x, y, resolutionFactor, cancellationToken);
        }

        protected override void OnSendingHttpRequestMessage(SendingHttpRequestMessageEventArgs e)
        {
            base.OnSendingHttpRequestMessage(e);
        }

        protected override void OnReceivedHttpResponseMessage(ReceivedHttpResponseMessageEventArgs e)
        {
            base.OnReceivedHttpResponseMessage(e);
        }
    }
}
