﻿using MauiApp1;
using Newtonsoft.Json;
using Tarnook.Mobile.Core.Extensions;
using ThinkGeo.Core;
using ThinkGeo.UI.Maui;

namespace HowDoISample.MapNavigation;

public partial class NavigationP : ContentPage
{
    private bool _initialized;
    // This locaiton suppose to be https://www.google.com/maps/place/37%C2%B049'43.2%22S+144%C2%B058'46.2%22E/@-37.8286667,144.9795,17z/data=!3m1!4b1!4m4!3m3!8m2!3d-37.8286667!4d144.9795?entry=ttu&g_ep=EgoyMDI1MTIwNy4wIKXMDSoKLDEwMDc5MjA2OUgBUAM%3D
    double lat = -37.8286667;
    double lon = 144.9795;

    public NavigationP()
    {
        InitializeComponent();
    }


    private async void MapLayer_OnSizeChanged(object sender, EventArgs e)
    {
        if (_initialized)
            return;
        _initialized = true;
        mapView.MapUnit = GeographyUnit.Meter;

        var overlay = new LayerOverlay();
              mapView.Overlays.Add(overlay);
        var wmtsLayer = new MyWmtsLayer();
        await wmtsLayer.OpenAsync();
        overlay.Layers.Add(wmtsLayer);

        var point = new PointShape(144.9794901, -37.828667);
        var projectedPoint = ProjectionConverter.Convert(4326, 3111, point);
        var locationLayer = new InMemoryFeatureLayer();
        locationLayer.InternalFeatures.Add(new Feature(projectedPoint));
        locationLayer.ZoomLevelSet.ZoomLevel01.DefaultPointStyle =
        PointStyle.CreateSimplePointStyle(PointSymbolType.Circle, GeoColors.Red, 10);
        locationLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;
        overlay.Layers.Add(locationLayer);


        // The loading speed is very slow and it also affect the base map (wmts layer) loading...
        var url = "https://maps.ffm.vic.gov.au/arcgis/rest/services/ocr_intel_services/MapServer/0/query";
        var arcgisVectorLayer = new ArcGisServerRestVectorAsyncLayer(url);
        arcgisVectorLayer.OutSR = "3111";

        await arcgisVectorLayer.OpenAsync();

        arcgisVectorLayer.ZoomLevelSet.ZoomLevel01.DefaultAreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColor.FromArgb(128, 255, 0, 0));
        arcgisVectorLayer.ZoomLevelSet.ZoomLevel01.DefaultLineStyle = LineStyle.CreateSimpleLineStyle(GeoColors.Blue, 2, false);
        arcgisVectorLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;
        overlay.Layers.Add(arcgisVectorLayer);

        //var arcGisLayer = new ArcGisServerRestRasterAsyncLayer(new Uri("https://maps.ffm.vic.gov.au/arcgis/rest/services/ocr_intel_services/MapServer/export"));
        //// Sets our parameters for image format.
        //arcGisLayer.ImageFormat = ArcGISServerRestLayerImageFormat.Png; // we can use the property 'ImageFormat' instead of the 'format' in parameters. When they coexist, the property is perferred.
        //// Sets our parameters for transparency.
        //arcGisLayer.Parameters.Add("transparent", "true");
        //// Specifies the layerId(s) you wish to display.  LayerId 2 is the county layer.
        //arcGisLayer.Parameters.Add("layers", "show:0");
        //overlay.Layers.Add(arcGisLayer);

        mapView.CenterPoint = projectedPoint;
        mapView.MapScale = MapConfig.MapZoomingDetails[1].Scale;
        await mapView.RefreshAsync();
    }

 


   
}