﻿Imports System.Collections.ObjectModel
Imports System.Runtime.Serialization.Formatters
Imports ThinkGeo.Core

Public Class CustomInMemoryLayer
  Inherits InMemoryFeatureLayer
  Protected Overrides Sub DrawCore(oGeoCanvas As GeoCanvas, labelsInAllLayers As Collection(Of SimpleCandidate))
    Dim oPointStyle As PointStyle = PointStyle.CreateSimpleSquareStyle(GeoColors.Red, 12)
    Dim oControlPoints = InternalFeatures
    Dim oDrawPoints As New Collection(Of PointShape)
    For Each oFeature In oControlPoints
      oDrawPoints.Add(CType(oFeature.GetShape, PointShape))
    Next oFeature
    Dim oLabels As New Collection(Of SimpleCandidate)

    oPointStyle.Draw(oDrawPoints, oGeoCanvas, oLabels, oLabels)

    'MyBase.DrawCore(canvas, labelsInAllLayers)
  End Sub
End Class
