﻿Imports System.Net
Imports ThinkGeo.Core

Public Class CustomWmtsLayer
  Inherits WmtsAsyncLayer
  Public Property moMap As CustomMapView
  Private mbIsPlanetData As Boolean = False
  Public Sub New(oUri As Uri, oMap As CustomMapView, bIsPlanetData As Boolean)
    MyBase.New(oUri)
    moMap = oMap
    mbIsPlanetData = bIsPlanetData
  End Sub
  Private msRequestMessage As String
  Protected Overrides Sub OnSendingHttpRequestMessage(e As SendingHttpRequestMessageEventArgs)

    Try

      If mbIsPlanetData Then
        e.HttpRequestMessage = mCreateHttpRequest(e.HttpRequestMessage)
      End If
      msRequestMessage = e.HttpRequestMessage.RequestUri.AbsoluteUri
      MyBase.OnSendingHttpRequestMessage(e)
    Catch ex As Exception
      Debug.WriteLine("Exception OnSendingHttpRequest: " + ex.Message)
    End Try
  End Sub
  Protected Overrides Sub OnDrawingException(e As DrawingExceptionLayerEventArgs)
    Debug.WriteLine("Exception: " + e.Exception.Message)
    Debug.WriteLine("Scale: " + CInt(moMap.CurrentScale).ToString)
    Debug.WriteLine("RequestUri: " + msRequestMessage)
    MyBase.OnDrawingException(e)
  End Sub
  Private Function mCreateHttpRequest(oCurrentHttpRequestMessage As Http.HttpRequestMessage) As Http.HttpRequestMessage
    Dim oHttpRequestMessageToReturn As Http.HttpRequestMessage
    Dim bCreateNewWebRequest As Boolean = False
    Dim sAbsoluteUri = oCurrentHttpRequestMessage.RequestUri.AbsoluteUri
    Dim bKeyMissing As Boolean = False
    Dim bProcStringMissing As Boolean = False

    If Not (sAbsoluteUri.Contains("api_key")) Then
      bKeyMissing = True
    End If

    If bKeyMissing Then
      sAbsoluteUri = sAbsoluteUri + ""
    End If

    oHttpRequestMessageToReturn = New Http.HttpRequestMessage(Http.HttpMethod.Get, New Uri(sAbsoluteUri))
    Return oHttpRequestMessageToReturn
  End Function
End Class
