﻿Imports ThinkGeo.UI.WinForms
Imports ThinkGeo.Core
Imports System.Collections.ObjectModel
Public Class Form1
  Public WithEvents MainMap As CustomMapView
  Private WithEvents moExtentOverlay As ExtentInteractiveOverlay
  Private moShapefile As CustomShapefile
  Private moSelectionLayer As New InMemoryFeatureLayer
  Private moPageLayoutStuff As CreatePageLayout
  Private WithEvents moTrackOverlay As TrackInteractiveOverlay
  Private WithEvents moEditOverlay As CustomEditOverlay
  Private WithEvents moExistingControlPointsLayer As InMemoryFeatureLayer
  Private Async Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
    MainMap = New CustomMapView With {
      .Dock = DockStyle.Fill
    }

    Controls.Add(MainMap)
    MainMap.BringToFront()

    MainMap.MapUnit = GeographyUnit.Meter
    MainMap.ExtentOverlay.PanMode = MapPanMode.StandardPanning
    Await mAddWmtsLayer()


  End Sub

  Private Async Function mAddWmtsLayer() As Task
    Dim oWmtsLayer As New CustomWmtsLayer(New Uri("https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/WMTS?"), MainMap, bIsPlanetData:=False)
    'Dim oWmtsLayer As New CustomWmtsLayer(New Uri("https://api.planet.com/basemaps/v1/mosaics/wmts"), MainMap, bIsPlanetData:=True)
    Dim s As String
    Dim o As Collection(Of String)

    '***** Open the layer and attempt to get capabilities
    Await oWmtsLayer.OpenAsync
    Try
      'Dim oUris = oWmtsLayer.GetRequestUris()
      o = oWmtsLayer.GetServerLayerNames
      s = oWmtsLayer.GetServerCapabilitiesXml
    Catch ex As Exception
      MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
      Return
    End Try



    'With oWmtsLayer
    '  .DrawingExceptionMode = DrawingExceptionMode.DrawAndThrowException
    '  .UserAgent = "Silvics Solutions"
    '  .ActiveLayerName = "Latest PS sen2_normalized_analytic monthly subscription"
    '  .ActiveStyleName = "default"
    '  .OutputFormat = "image/png"
    '  .TileMatrixSetName = "GoogleMapsCompatible15"
    '  Await .OpenAsync
    'End With

    With oWmtsLayer
      .DrawingExceptionMode = DrawingExceptionMode.DrawException
      .UserAgent = "Silvics Solutions"
      .ActiveLayerName = "USGSTopo"
      .ActiveStyleName = "default"
      .OutputFormat = "image/png"
      .TileMatrixSetName = "GoogleMapsCompatible"
      Await .OpenAsync
    End With

    Dim oOverlay As New LayerOverlay With {.Name = "Layers"}
    oOverlay.Layers.Add(oWmtsLayer)

    MainMap.Overlays.Add("Layers", oOverlay)
    MainMap.CurrentExtent = New RectangleShape(-20037507.8427882, 20037508.2314698, 20037507.8407383, -20037508.2527101)

    'Await MainMap.RefreshAsync

  End Function
  Private Async Sub mTestSerialization(oShapefile As CustomWmtsLayer)
    Dim sSerializationPath As String = "..\..\Data\SerializationTest.xml"
    Dim oGeoSerializer As New GeoSerializer

    '***** Set the 'Name' property on the shapefile
    oShapefile.Name = "AreasOfConcern"
    Await oShapefile.CloseAsync()
    '***** Serialize the shapefile
    oGeoSerializer.Serialize(oShapefile, sSerializationPath)

    '***** Deserialize the shapefile
    Dim oObjLayer = oGeoSerializer.Deserialize(sSerializationPath, IO.FileAccess.Read)

    '***** Note that the 'Name' public property and back field name are not populated 
    '***** in the deserialized shapefile
    Dim oDeserializedShapefile = CType(oObjLayer, CustomWmtsLayer)


  End Sub


End Class
