﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using ThinkGeo.Core;

namespace ConsoleApp1
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string gdbPath = @"D:\Source\test\DVT_Midstream.gdb\DVT_Midstream.gdb";
            string featureLayerName = @"PIPELINES";
            int srid;

            if (Directory.Exists(gdbPath))
            {
                FileGeoDatabaseFeatureSource source = new FileGeoDatabaseFeatureSource(gdbPath, featureLayerName);
                source.Open();

                string projectionString = source.GetInternalProj4ProjectionParametersString();

                if (!string.IsNullOrEmpty(projectionString))
                {
                    srid = Projection.ConvertProjStringToEpsg(projectionString);
                }

                source.Close();
            }
            else
            {
                throw new DirectoryNotFoundException($"The directory {gdbPath} does not exist. Please check the path to the data source.");
            }

        }
    }
}
