﻿Imports ThinkGeo.UI.WinForms
Imports ThinkGeo.Core
Imports System.Collections.ObjectModel
Public Class Form1
  Public WithEvents MainMap As CustomMapView
  Private WithEvents mExtentOverlay As ExtentInteractiveOverlay
  Private Async Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
    MainMap = New CustomMapView With {
      .Dock = DockStyle.Fill
    }

    Controls.Add(MainMap)
    MainMap.BringToFront()
    mExtentOverlay = MainMap.ExtentOverlay
    MainMap.MapUnit = GeographyUnit.Meter
    MainMap.ExtentOverlay.PanMode = MapPanMode.StandardPanning
    Await mAddWmtsLayer()


  End Sub
  Private moWmtsLayer As Object

  Public Sub New()
    InitializeComponent()

    ThinkGeoDebugger.LogType = ThinkGeoLogType.All
    ThinkGeoDebugger.LogLevel = ThinkGeoLogLevel.Error
  End Sub

  Private Async Function mAddWmtsLayer() As Task
    'moWmtsLayer = New WmtsAsyncLayer(New Uri("https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/WMTS?")) ', MainMap, bIsPlanetData:=False)
    moWmtsLayer = New CustomWmtsLayer(New Uri("https://api.planet.com/basemaps/v1/mosaics/wmts"), MainMap, bIsPlanetData:=True)
    Dim s As String
    Dim o As Collection(Of String)

    '***** Open the layer and attempt to get capabilities
    Await moWmtsLayer.OpenAsync
    Try
      'Dim oUris = oWmtsLayer.GetRequestUris()
      o = moWmtsLayer.GetServerLayerNames
      s = moWmtsLayer.GetServerCapabilitiesXml
    Catch ex As Exception
      MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
      Return
    End Try

    With CType(moWmtsLayer, CustomWmtsLayer)
      .Name = "Planet"
      .DrawingExceptionMode = DrawingExceptionMode.DrawException
      .UserAgent = "Silvics Solutions"
      .ActiveLayerName = "Latest PS sen2_normalized_analytic monthly subscription"
      .ActiveStyleName = "default"
      .OutputFormat = "image/png"
      .TileMatrixSetName = "GoogleMapsCompatible15"
      .IsPlanetImagery = True
      .LowerScale = 0.0
      .UpperScale = Double.MaxValue
      .WmtsServerEncodingType = WmtsServerEncodingType.Restful
    End With

    'With moWmtsLayer
    '  .DrawingExceptionMode = DrawingExceptionMode.DrawException
    '  .UserAgent = "Silvics Solutions"
    '  .ActiveLayerName = "USGSTopo"
    '  .ActiveStyleName = "default"
    '  .OutputFormat = "image/png"
    '  .TileMatrixSetName = "GoogleMapsCompatible"
    '  Await .OpenAsync
    'End With

    Dim oOverlay As New LayerOverlay With {.Name = "Layers"}
    oOverlay.Layers.Add("Planet", moWmtsLayer)

    MainMap.Overlays.Add("Layers", oOverlay)
    MainMap.CurrentExtent = New RectangleShape(-10393133.5873687, 3618855.81205749, -10319360.9359079, 3577099.35569482)


    'Await MainMap.RefreshAsync

  End Function
  Private Sub mTestSerialization(oWmtsLayer As CustomWmtsLayer)
    Dim sSerializationPath As String = "..\..\Data\SerializationTest.xml"
    Dim oGeoSerializer As New GeoSerializer
    Dim oPropsToSerialize As New WmtsSerializationObject

    With oPropsToSerialize
      .ActiveLayerName = oWmtsLayer.ActiveLayerName
      .ActiveStyleName = oWmtsLayer.ActiveStyleName
      .BaseUri = oWmtsLayer.ServerUri.AbsoluteUri
      .IsPlanetImagery = oWmtsLayer.IsPlanetImagery
      .Name = oWmtsLayer.Name
      .OutputFormat = oWmtsLayer.OutputFormat
      .TileMatrixSetName = oWmtsLayer.TileMatrixSetName
      .UserAgent = oWmtsLayer.UserAgent
      .WmtsDrawingExceptionMode = oWmtsLayer.DrawingExceptionMode
    End With

    '***** Serialize the shapefile
    oGeoSerializer.Serialize(oPropsToSerialize, sSerializationPath)

    '***** Deserialize the shapefile
    Dim oObjLayer = oGeoSerializer.Deserialize(sSerializationPath, IO.FileAccess.Read)

    '***** Note that the 'Name' public property and back field name are not populated 
    '***** in the deserialized shapefile
    Dim oDeserializedProps = CType(oObjLayer, WmtsSerializationObject)

    Dim oOverlay = CType(MainMap.Overlays("Layers"), LayerOverlay)
    oOverlay.Layers.Remove("Planet")

    '***** Now create the actual wmts layer
    Dim oNewWmtsLayer As New CustomWmtsLayer(New Uri(oDeserializedProps.BaseUri), MainMap, oDeserializedProps.IsPlanetImagery)

    With oDeserializedProps
      oNewWmtsLayer.Name = .Name
      oNewWmtsLayer.ActiveLayerName = .ActiveLayerName
      oNewWmtsLayer.ActiveStyleName = .ActiveStyleName
      oNewWmtsLayer.DrawingExceptionMode = .WmtsDrawingExceptionMode
      oNewWmtsLayer.OutputFormat = .OutputFormat
      oNewWmtsLayer.TileMatrixSetName = .TileMatrixSetName
    End With

    oOverlay.Layers.Add(oNewWmtsLayer)

  End Sub

  Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
    mTestSerialization(CType(moWmtsLayer, WmtsAsyncLayer))
  End Sub

  Private Sub MainMap_CurrentExtentChanged(sender As Object, e As CurrentExtentChangedMapViewEventArgs) Handles MainMap.CurrentExtentChanged
    ' Debug.WriteLine(e.NewExtent.ToString)
  End Sub
End Class
