﻿using MapTestBlazor2.Extensions;
using SkiaSharp;
using System.Collections;
using ThinkGeo.Core;

namespace MapTestBlazor2.Components
{

    public class MapUtilities
    {
        public static string staticOverlayKey = "StaticOverlay";
        public static string indexPath = GlobalSettings.BasePath + "ActiveMap\\";

        private static List<GeoImage> _geoImageList = new List<GeoImage>();
        public static List<GeoImage> GeoImageList
        {
            get { return _geoImageList; }
        }

        private static SortedList _geoImageIndexMap = new SortedList();
        public static SortedList GeoImageIndexMap
        {
            get { return _geoImageIndexMap; }
        }

        public static int GetGeoImageIndex(string name)
        {
            if (GeoImageIndexMap == null || GeoImageIndexMap.Count == 0)
            {
                try
                {
                    LoadIcons();
                }
                catch (PlatformNotSupportedException)
                {
                    return -1;
                }
            }

            if (GeoImageIndexMap != null && GeoImageIndexMap.ContainsKey(name))
            {
                return GeoImageIndexMap[name] is int index ? index : -1;
            }
            else if (GeoImageIndexMap != null && GeoImageIndexMap.ContainsKey("Generic Missing Icon"))
            {
                return GeoImageIndexMap["Generic Missing Icon"] is int missingIndex ? missingIndex : -1;
            }
            else
            {
                return -1;
            }
        }


        #region Icon Methods
        public static void LoadIcons()
        {
            string iconPath = GlobalSettings.BasePath + "Icons\\";

            int index = 0;
            foreach (string filename in Directory.GetFiles(iconPath))
            {
                if (Path.GetExtension(filename) == ".png")
                {
                    string name = Path.GetFileNameWithoutExtension(filename);
                    _geoImageList.Add(new GeoImage(filename));
                    GeoImageIndexMap[name] = index;
                    index++;
                }
            }
        }

        private static void AddGeoIcon(string filename)
        {
            // Create a bitmap from the file
            SKBitmap bitmap = SKBitmap.Decode(filename);

            // Resize using SKImageInfo and SKFilterQuality
            var skImageInfo = new SKImageInfo(32, 32, bitmap.ColorType, bitmap.AlphaType);
            bitmap = bitmap.Resize(skImageInfo, SKSamplingOptions.Default);

            // Set the transparent color (assuming the original bitmap uses a specific color for transparency, e.g., magenta)
            bitmap.MakeColorTransparent(SKColors.Fuchsia);

            MemoryStream imageStream = new MemoryStream();
            bitmap.Encode(SKEncodedImageFormat.Png, 100).SaveTo(imageStream);
            GeoImage image = new GeoImage(imageStream.ToArray());

            _geoImageList.Add(image);

            imageStream.Dispose();
            bitmap.Dispose();
        }


    }
    #endregion
}

