﻿
using System.Text;

using ThinkGeo.Core;
namespace HowDoISample
{
    internal static class MappingExtensions
    {



        private static readonly Lazy<ProjectionConverter> _converter = new Lazy<ProjectionConverter>(() =>
        {
            var converter = new ProjectionConverter(
                MapConfig.ProjString,
                Projection.GetDecimalDegreesProjString());
                converter.Open();
                return converter;
            }, LazyThreadSafetyMode.ExecutionAndPublication);

        public static ProjectionConverter GetConverter()
        {
            var converter = _converter.Value;

            if (!converter.IsOpen)
            {
                lock (_converter)
                {
                    if (!converter.IsOpen)
                    {
                        converter.Open();
                    }
                }
            }

            return converter;
        }


        public static ThinkGeo.Core.Feature ConvertLatLonToMeters(this ThinkGeo.Core.Feature feature)
        {
            var converter = GetConverter();
            var projectedFeature = converter.ConvertToInternalProjection(feature);
            return projectedFeature;
        }


        public static PointShape ConvertLatLonToMeters(double latitude, double longitude, bool shouldCloseConverter = false)
        {
            try
            {
                var converter = GetConverter();
                var point = new PointShape(longitude, latitude);
                var projectedPoint = converter.ConvertToInternalProjection(point);
                return projectedPoint as PointShape;
            }
            catch(Exception ex)
            {
                return null;
            }
            
        }

        public static PointShape ConvertMetersToLatLong(this PointShape point)
        {
            var converter = GetConverter();
            var projectedPoint = converter.ConvertToExternalProjection(point);
            return projectedPoint as PointShape;
        }

        internal static RectangleShape ConvertMetersToLatLong(this RectangleShape extent)
        {
            var converter = GetConverter();
            var projectedPoint = converter.ConvertToExternalProjection(extent);
            return projectedPoint;
        }

        public static double CalculateDistanceBetweenCoordinates(double fromLatitude, double fromLongitude, double toLatitude, double toLongitude)
        {
            double x = 69.1 * (toLatitude - fromLatitude);
            double y = 69.1 * (toLongitude - fromLongitude) * Math.Cos(fromLatitude / 57.3);

            //Convert to KM by multiplying 1.609344
            return (Math.Sqrt(x * x + y * y) * 1.609344);
        }

        
        public static double GetRandomNumber(int minimum, int maximum)
        {
            Random random = new Random();
            return random.NextDouble() * (maximum - minimum) + minimum;

            // return random.Next(minimum, maximum) + random.NextDouble();
        }

        public static RectangleShape ConvertLatLonToMeters(this RectangleShape rectangle)
        {
            var converter = GetConverter();
            var projectedFeature = converter.ConvertToInternalProjection(rectangle);
            return projectedFeature;
        }
    }
}
