﻿using MauiApp1;
using Microsoft.Maui.Devices.Sensors;
using NetTopologySuite.Geometries;
using System.Threading;
using ThinkGeo.Core;
using ThinkGeo.UI.Maui;

namespace HowDoISample.MapNavigation;

public partial class NavigationP : ContentPage
{
    private bool _initialized;
    // This locaiton suppose to be https://www.google.com/maps/place/37%C2%B049'43.2%22S+144%C2%B058'46.2%22E/@-37.8286667,144.9795,17z/data=!3m1!4b1!4m4!3m3!8m2!3d-37.8286667!4d144.9795?entry=ttu&g_ep=EgoyMDI1MTIwNy4wIKXMDSoKLDEwMDc5MjA2OUgBUAM%3D
    double lat = -37.8286667;
    double lon = 144.9795;

    public NavigationP()
    {
        InitializeComponent();
    }


    private async void MapLayer_OnSizeChanged(object sender, EventArgs e)
    {
        if (_initialized)
            return;
        _initialized = true;
        mapView.MapUnit = GeographyUnit.Meter;

        var overlay = new MyWmtsLayerOverlay { TileHeight = MapConfig.TileSize, TileWidth = MapConfig.TileSize, ZoomLevelSet = new GDA2020ZoomLevelSet(), TileType = TileType.SingleTile };
        mapView.Overlays.Add(overlay);
        overlay.Layers.Add(new MyMapLayer());
        InMemoryFeatureLayer featureLayer = new InMemoryFeatureLayer();
        featureLayer.ZoomLevelSet = new GDA2020ZoomLevelSet();

        // I assume we need this?
        featureLayer.Projection = new Projection(MapConfig.ProjString);


        var blankCircleStyle = PointStyle.CreateSimpleCircleStyle(GeoColors.DarkGreen, 40, GeoColors.White);
        blankCircleStyle.DrawingLevel = DrawingLevel.LabelLevel;

        var textStyle = new TextStyle("Name", new GeoFont("sans-serif", 12, DrawingFontStyles.Bold), GeoBrushes.White)
        {
            Mask = new AreaStyle(GeoPens.Black, GeoBrushes.White),
            MaskMargin = new DrawingMargin(2, 2, 2, 2),
            YOffsetInPixel = -10
        }; 

        featureLayer.ZoomLevelSet.ZoomLevel01.DefaultPointStyle = new PointStyle(PointSymbolType.Circle, 12, GeoBrushes.Red, GeoPens.White);
        featureLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

        // The point look wrong on the map...? is that because the projection conversion or the tile calculation?
        var point = MappingExtensions.ConvertLatLonToMeters(lat, lon);

        ThinkGeo.Core.Feature feature = new Feature(point.X, point.Y, "X");
        feature.ColumnValues.Add("Name", "Here");
        featureLayer.InternalFeatures.Add(feature);

        overlay.Layers.Add(featureLayer);

        mapView.CenterPoint = point;
        mapView.MapScale = MapConfig.MapZoomingDetails[0].Scale;

        await mapView.RefreshAsync();
    }

 


   
}