﻿using System.Linq;
using System.Windows.Media;
using ThinkGeo.Core;
using ThinkGeo.UI.Wpf;

namespace TestApp
{
    /// <summary>
    /// Interaction logic for MapControl.xaml
    /// </summary>
    public partial class MapControl
    {

        /// <summary>
        /// ThinkGeo Map
        /// </summary>
        public MapView Map { get; set; }

        public MapControl()
        {
            InitializeComponent();
            DataContext = this;
            Map = CreateMap();
            Map.Loaded += (sender, args) => OnLoaded();
        }

        public static MapView CreateMap()
        {
            MapView map = new MapView
            {
                Background = Brushes.LightSkyBlue,
                FocusVisualStyle = null
            };

            map.MapUnit = GeographyUnit.Meter;

            // Add three more zoom layers
            map.ZoomScales.Add(map.ZoomScales.Last() / 2);
            map.ZoomScales.Add(map.ZoomScales.Last() / 2);
            map.ZoomScales.Add(map.ZoomScales.Last() / 2);
            map.MinimumScale = map.ZoomScales.Last();

            if (map.ZoomScales.Count == 20) throw new System.Exception("ZoomScales count wrong CreateMap");
            return map;
        }

        private async void OnLoaded()
        {
            if (Map.ZoomScales.Count == 20) throw new System.Exception("ZoomScales count wrong OnLoaded before");
            Map.MapUnit = GeographyUnit.Meter;
            if (Map.ZoomScales.Count == 20) throw new System.Exception("ZoomScales count wrong OnLoaded after");
        }

    }
}
