using ThinkGeo.Core;
using ThinkGeo.UI.WinForms;

namespace WinFormsApp1
{
    public partial class Form1 : Form
    {
        private MapView mapView;
        public Form1()
        {
            InitializeComponent();

            mapView = new ThinkGeo.UI.WinForms.MapView();
            mapView.Size = new System.Drawing.Size(800, 450);
            mapView.Dock = DockStyle.Fill;
            Controls.Add(this.mapView);
            this.Load += OnLoad;
        }

        private void OnLoad(object? sender, EventArgs e)
        {
            // Set the map's unit of measurement to meters(Spherical Mercator)
            mapView.MapUnit = GeographyUnit.Meter;
            mapView.DragDrop += (o, args) =>
            {
	            System.Diagnostics.Debug.WriteLine("DragDrop");

			};
            mapView.DragEnter += (o, args) =>
            {
	            System.Diagnostics.Debug.WriteLine("DragEnter");

			};
            mapView.DragLeave+= (o, args) =>
            {
	            System.Diagnostics.Debug.WriteLine("DragLeave");

			};
            mapView.DragOver += (o, args) =>
            {
	            System.Diagnostics.Debug.WriteLine("DragOver");
			};

            // Add Cloud Maps as a background overlay
            var thinkGeoCloudVectorMapsOverlay = new ThinkGeoCloudVectorMapsOverlay
            {
                ClientId = ClientId,
                ClientSecret = ClientSecret,
                MapType = ThinkGeoCloudVectorMapsMapType.Light,
                // Set up the tile cache for the ThinkGeoCloudVectorMapsOverlay, passing in the location and an ID to distinguish the cache. 
                TileCache = new FileRasterTileCache(@".\cache", "thinkgeo_vector_light")
            };
            mapView.Overlays.Add(thinkGeoCloudVectorMapsOverlay);

            // Set the map extent
            mapView.CurrentExtent = new RectangleShape(-10786436, 3918518, -10769429, 3906002);
            mapView.ExtentOverlay.MapMouseMove += ExtentOverlay_MapMouseMove;
            _ = mapView.RefreshAsync();
        }

        private void ExtentOverlay_MapMouseMove(object? sender, MapMouseMoveInteractiveOverlayEventArgs e)
        {
            System.Diagnostics.Debug.WriteLine("ExtentOverlay_MapMouseMove");
        }

        public static string ClientId = "AOf22-EmFgIEeK4qkdx5HhwbkBjiRCmIDbIYuP8jWbc~";
        public static string ClientSecret = "xK0pbuywjaZx4sqauaga8DMlzZprz0qQSjLTow90EhBx5D8gFd2krw~~";
    }
}
