﻿Imports System.Collections.ObjectModel
Imports ThinkGeo.Core

Public Class ZoomLevelHelper
	Public Shared ZoomLevels As Collection(Of ZoomLevel)
	Public Enum EnumSymbolType
		PointSymbol = 1
		LineSymbol = 2
		AreaSymbol = 3
		Text = 4
		None = 4
	End Enum
	Public Enum EnumDrawingBehavior
		DrawLayer = 1
		DrawLabelsAndSelection = 2
		DrawEverything = 3
		Unknown = 4
	End Enum
	Public Enum EnumScaleMode
		ShowAtAllScales = 1
		ShowAtSetScales = 2
		UseLayerScaleRanges = 3
	End Enum
	Public Enum EnumScaleRangeSymbolBehavoir
		UseSameSymbol = 1
		UseSeparateSymbols = 2
	End Enum
	Public Enum EnumZoomSpecsType
		DrawingStyle = 1
		LabelStyle = 2
	End Enum
	Public Shared ReadOnly Property MaxZoomLevel As ZoomLevel
		Get
			Return New ZoomLevel(129761280 * 2)
		End Get
	End Property
	Public Shared ReadOnly Property MinZoomLevel As ZoomLevel
		Get
			Return New ZoomLevel(0)
		End Get
	End Property
	Public Shared Function GetNextHigherZoomLevel(ByVal oCurrentZoom As ZoomLevel) As ZoomLevel
		Dim oZoom As ZoomLevel
		Dim oNextZoom As ZoomLevel = Nothing

		For i = ZoomLevels.Count - 1 To 0 Step -1
			oZoom = ZoomLevels(i)
			If oZoom.Scale > oCurrentZoom.Scale Then
				oNextZoom = oZoom
				Exit For
			End If
		Next i

		'***** If we could not find the next higher zoom level it means 
		'***** oCurrentZoom is already the highest zoom
		If oNextZoom Is Nothing Then
			oNextZoom = New ZoomLevel(-1)
		End If

		Return oNextZoom
	End Function
	Public Shared Function GetNextHigherScale(ByVal dScale As Double) As Double
		Dim oZoom As ZoomLevel
		Dim oNextZoom As ZoomLevel = Nothing

		For i = ZoomLevels.Count - 1 To 0 Step -1
			oZoom = ZoomLevels(i)
			If oZoom.Scale > dScale Then
				oNextZoom = oZoom
				Exit For
			End If
		Next i

		'***** If we could not find the next higher zoom level it means 
		'***** oCurrentZoom is already the highest zoom
		If oNextZoom Is Nothing Then
			oNextZoom = New ZoomLevel(-1)
		End If

		Return oNextZoom.Scale
	End Function

	Public Shared Sub InitZoomLevels()
		'***** Initialize default set of zoom levels
		Dim oZoomLevel As ZoomLevel

		ZoomLevels = New Collection(Of ZoomLevel)
		oZoomLevel = New ZoomLevel(129761280) '***** 1" = 2048 miles, 129,761,280
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(64880640) '***** 1" = 1024 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(32440320) '***** 1" = 512 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(24330240) '***** 1" = 384 miles
		ZoomLevels.Add(oZoomLevel)



		oZoomLevel = New ZoomLevel(16220160) '***** 1" = 256 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(8110080) '***** 1" = 128 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(4055040) '***** 1" = 64 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(3041280) '***** 1" = 48 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(2027520) '***** 1" = 32 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(1520640) '***** 1" = 24 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(1013760) '***** 1" = 16 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(760320) '***** 1" = 12 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(506880) '***** 1" = 8 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(443520) '***** 1" = 7 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(380160) '***** 1" = 6 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(316800) '***** 1" = 5 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(253440) '***** 1" = 4 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(221760)  '***** 1" = 3 1/2 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(190080)  '***** 1" = 3 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(158400)  '***** 1" = 2 1/2 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(126720) '***** 1" = 2 miles
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(110880)  '***** 1" = 1 3/4 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(95040)  '***** 1" = 1 1/2 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(79200)  '***** 1" = 1 1/4 mile
		ZoomLevels.Add(oZoomLevel)

		'oZoomLevel = New ZoomLevel(84480)  '***** 1" = 1 1/3 mile
		'ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(63360)  '***** 1" = 1 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(56320)  '***** 1" = 0.8888 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(50688)  '***** 1" = 0.8 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(42240)  '***** 1" = 02/3 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(36206)  '***** 1" = 0.5714 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(31680)  '***** 1" = 0.5 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(28160)  '***** 1" = 0.4444 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(25344)  '***** 1" = 0.4 mile
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(24000)  '***** 1" = 2000 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(21120)  '***** 1" = 1760 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(18000)  '***** 1" = 1500 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(16800)  '***** 1" = 1400.00 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(15840)  '***** 1" = 1320 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(14080)  '***** 1" = 1173.33 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(12000)  '***** 1" = 1000 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(10800)  '***** 1" = 900 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(9000)   '***** 1" = 750 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(7920)   '***** 1" = 660 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(6000)   '***** 1" = 500 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(4800)   '***** 1" = 400 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(4200)   '***** 1" = 350 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(3600)   '***** 1" = 300 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(3000)   '***** 1" = 250 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(2400)   '***** 1" = 200 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(1800)   '***** 1" = 150 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(1200)   '***** 1" = 100 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(900)   '***** 1" = 75 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(600)   '***** 1" = 50 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(450)   '***** 1" = 37.5 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(300)   '***** 1" = 25 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(150)   '***** 1" = 12.5 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(75)   '***** 1" = 6.25 feet
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(12)   '***** 1" = 1 foot
		ZoomLevels.Add(oZoomLevel)

		oZoomLevel = New ZoomLevel(1)   '***** 1" = 1"
		ZoomLevels.Add(oZoomLevel)

	End Sub



	Public Shared Sub ApplyCustomZoomLevels(ByVal oZoomLevelSet As ZoomLevelSet, ByVal eSymbolType As EnumSymbolType, Optional ByVal oStyle As Style = Nothing)
		Dim oNewZoomLevel As ZoomLevel
		Dim i As Integer = 0

		Select Case eSymbolType
			Case EnumSymbolType.AreaSymbol
				With oZoomLevelSet
					.CustomZoomLevels.Clear()
					For Each oZoomLevel As ZoomLevel In ZoomLevels
						oNewZoomLevel = New ZoomLevel(oZoomLevel.Scale)
						If oStyle Is Nothing Then
							'oNewZoomLevel.DefaultAreaStyle = GetDefaultAreaStyle()
							'oNewZoomLevel.CustomStyles.Add(GetDefaultAreaStyle)
						Else
							'oNewZoomLevel.DefaultAreaStyle = CType(oStyle, AreaStyle)
							oNewZoomLevel.CustomStyles.Add(CType(oStyle, AreaStyle))
						End If
						.CustomZoomLevels.Add(oNewZoomLevel)
					Next oZoomLevel
				End With
			Case EnumSymbolType.LineSymbol
				With oZoomLevelSet
					.CustomZoomLevels.Clear()
					For Each oZoomLevel As ZoomLevel In ZoomLevels
						oNewZoomLevel = New ZoomLevel(oZoomLevel.Scale)
						If oStyle Is Nothing Then
							'oNewZoomLevel.DefaultLineStyle = GetDefaultLineStyle()
							'oNewZoomLevel.CustomStyles.Add(GetDefaultLineStyle)
						Else
							'oNewZoomLevel.DefaultLineStyle = CType(oStyle, LineStyle)
							oNewZoomLevel.CustomStyles.Add(CType(oStyle, LineStyle))
						End If

						.CustomZoomLevels.Add(oNewZoomLevel)
					Next oZoomLevel
				End With
			Case EnumSymbolType.PointSymbol
				With oZoomLevelSet
					.CustomZoomLevels.Clear()
					For Each oZoomLevel As ZoomLevel In ZoomLevels
						oNewZoomLevel = New ZoomLevel(oZoomLevel.Scale)
						If oStyle Is Nothing Then
							'oNewZoomLevel.DefaultPointStyle = GetDefaultPointStyle()
							'oNewZoomLevel.CustomStyles.Add(GetDefaultPointStyle)
						Else
							'oNewZoomLevel.DefaultPointStyle = CType(oStyle, PointStyle)
							oNewZoomLevel.CustomStyles.Add(CType(oStyle, PointStyle))
						End If
						.CustomZoomLevels.Add(oNewZoomLevel)
					Next oZoomLevel
				End With
			Case EnumSymbolType.Text
				With oZoomLevelSet
					.CustomZoomLevels.Clear()
					For Each oZoomLevel As ZoomLevel In ZoomLevels
						oNewZoomLevel = New ZoomLevel(oZoomLevel.Scale)
						If oStyle Is Nothing Then
							'oNewZoomLevel.DefaultPointStyle = GetDefaultPointStyle()
							'oNewZoomLevel.CustomStyles.Add(GetDefaultPointStyle)
						Else
							oNewZoomLevel.DefaultTextStyle = CType(oStyle, CustomTextStyle)
							'oNewZoomLevel.CustomStyles.Add(CType(oStyle, CustomTextStyle))
						End If
						.CustomZoomLevels.Add(oNewZoomLevel)
					Next oZoomLevel
				End With

			Case EnumSymbolType.None
				With oZoomLevelSet
					.CustomZoomLevels.Clear()
					For Each oZoomLevel As ZoomLevel In ZoomLevels
						.CustomZoomLevels.Add(oZoomLevel)
					Next oZoomLevel
				End With
		End Select
	End Sub
	Public Shared Sub ApplyCustomZoomLevels(oZoomScales As Collection(Of Double))
		'***** In this overload we are only setting the Zoom Scales on a map, which no longer
		'***** has a Zoom Level collection, as it has become obsolete.
		'***** SET 10/21/2025
		oZoomScales.Clear()
		For Each oZoomLevel As ZoomLevel In ZoomLevels
			oZoomScales.Add(oZoomLevel.Scale)
		Next oZoomLevel

	End Sub

	'Public Shared Function FormatScaleDisplay(ByVal dScale As Double, eScaleDisplayMethod As Enums.EnumScaleDisplayMethod) As String
	'  Dim sFormattedScale As String = String.Empty
	'  Dim sFormat As String

	'  Select Case eScaleDisplayMethod
	'    Case Enums.EnumScaleDisplayMethod.Absolute
	'      sFormattedScale = String.Format("1:{0:#,###}", dScale)
	'    Case Enums.EnumScaleDisplayMethod.CentimetersMeter
	'      If dScale / 100 >= 1 Then
	'        sFormat = "{0:#,###}"
	'      Else
	'        sFormat = "{0:0.00}"
	'      End If
	'      sFormattedScale = String.Format(sFormat, (dScale / 100))
	'    Case Enums.EnumScaleDisplayMethod.InchesFeet
	'      If dScale / 12 >= 1 Then
	'        sFormat = "{0:#,###} ft/in"
	'      Else
	'        sFormat = "{0:0.00} ft/in"
	'      End If
	'      sFormattedScale = String.Format(sFormat, (dScale / 12))
	'  End Select

	'  Return sFormattedScale
	'End Function

End Class