﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ThinkGeo.Core;

namespace HowDoISample
{
    public class GDA2020ZoomLevelSet : ZoomLevelSet
    {
        public GDA2020ZoomLevelSet() : base(256, MapConfig.VicGridFullExtent, GeographyUnit.Meter)
        {
            // Clear any default levels created by the base ctor (if any)
            this.CustomZoomLevels.Clear();

            foreach (var mapZoomDetails in MapConfig.MapZoomingDetails)
            {
                var zoomLevel = new ZoomLevel(mapZoomDetails.Scale);
                this.CustomZoomLevels.Add(zoomLevel);
            }
        }
    }
}
