﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ThinkGeo.Core;

namespace HowDoISample
{
    public static class MapConfig
    {
        public static readonly int TileSize = 256;

        public static readonly double OriginX = -3.86758975458376E7;
        public static readonly double OriginY = 6.21452549892117E7;

        // https://spatialreference.org/ref/epsg/7899/ the proj string is Proj4, not really sure it is correct or not
        public static readonly string ProjString = "+proj=lcc +lat_0=-37 +lon_0=145 +lat_1=-36 +lat_2=-38 +x_0=2500000 +y_0=2500000 +ellps=GRS80 +units=m +no_defs +type=crs";

        public static readonly RectangleShape VicGridFullExtent = new RectangleShape(minX: 1529124.3499168884, minY: 1928459.5203903895, maxX: 3564950.795010276, maxY: 3048537.839936875);
        public static readonly RectangleShape VicGridInitialExtent = new RectangleShape(minX: 1425890.7196299564, minY: 1610736.4225368542, maxX: 2065788.6614343557, maxY: 2536693.753962169);

        public static readonly List<ZoomLevelDetails> MapZoomingDetails = new List<ZoomLevelDetails>
        {
            new ZoomLevelDetails(0, 8000000d, 2116.670900008467),
            new ZoomLevelDetails(1, 4000000d, 1058.3354500042335),
            new ZoomLevelDetails(2, 2000000d, 529.1677250021168),
            new ZoomLevelDetails(3, 1000000d, 264.5838625010584),
            new ZoomLevelDetails(4, 500000d, 132.2919312505292),
            new ZoomLevelDetails(5, 250000d, 66.1459656252646),
            new ZoomLevelDetails(6, 175000d, 46.30217593768521),
            new ZoomLevelDetails(7, 100000d, 26.458386250105836),
            new ZoomLevelDetails(8, 50000d, 13.229193125052918),
            new ZoomLevelDetails(9, 25000d, 6.614596562526459),
            new ZoomLevelDetails(10, 10000d, 2.6458386250105836),
            new ZoomLevelDetails(11, 5000d, 1.3229193125052918),
            new ZoomLevelDetails(12, 2500d, 0.6614596562526459)
        };
    }
}
