﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ThinkGeo.Core;
using static System.Runtime.InteropServices.JavaScript.JSType;

namespace HowDoISample
{
    public class MyMapLayer : WebRasterXyzTileAsyncLayer
    {
        public MyMapLayer() : base(MapConfig.TileSize, GeographyUnit.Meter, MapConfig.VicGridFullExtent)
        {
            this.Projection = new Projection(MapConfig.ProjString);
            this.TileMatrixSet = TileMatrixSet.CreateTileMatrixSet(MapConfig.TileSize, MapConfig.VicGridFullExtent, GeographyUnit.Meter, MapConfig.MapZoomingDetails.Select(p => p.Scale));
        }

        protected override Task<string> GetImageUriAsyncCore(int zoomLevel, long x, long y, float resolutionFactor)
        {
            // The generated y and x is not correct all the time...Have to go through below method to calculate the X Y in server
            Point calculated = CalculateServerTileXY(zoomLevel, x, y);

            string url = $"https://mymapserver.com/arcgis/rest/services/mapscape_gda2020/MapServer/tile/{zoomLevel}/{calculated.Y}/{calculated.X}?token=tokenHere";
            return Task.FromResult(url);
        }

        /// <summary>
        /// This method calculate the X Y in server, but it seems not correct when the zoom Level increase.
        /// </summary>
        /// <param name="zoomLevel"></param>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        private Point CalculateServerTileXY(int zoomLevel, long x, long y)
        {
            try
            {
                // Get resolution for this level
                var zoomDetail = MapConfig.MapZoomingDetails.FirstOrDefault(z => z.ZoomLevel == zoomLevel);
                if (zoomDetail == null)
                    throw new Exception($"Zoom Level does not support");

                double resolution = zoomDetail.Resolution;

                // Calculate the world coordinate for this tile's top-left corner
                // ThinkGeo gives us x,y relative to BoundingBox, convert to world coords
                double worldX = MapConfig.VicGridFullExtent.MinX + (x * MapConfig.TileSize * resolution);
                double worldY = MapConfig.VicGridFullExtent.MaxY - (y * MapConfig.TileSize * resolution);

                // Now calculate tile indices using the actual origin your server expects
                long serverTileX = (long)Math.Floor((worldX - MapConfig.OriginX) / (resolution * MapConfig.TileSize));
                long serverTileY = (long)Math.Floor((MapConfig.OriginY - worldY) / (resolution * MapConfig.TileSize));

                return new Point(serverTileX, serverTileY);
            }
            catch (Exception ex)
            {
                return new Point(x, y);
            }
        }

    }
}
