﻿using Microsoft.Maui.Devices.Sensors;
using NetTopologySuite.Geometries;
using System.Threading;
using ThinkGeo.Core;
using ThinkGeo.UI.Maui;

namespace HowDoISample.MapNavigation;

public partial class NavigationP : ContentPage
{
    private bool _initialized;
    // This locaiton suppose to be https://www.google.com/maps/place/National+Gallery+of+Victoria/@-37.8093153,144.9946003,14z/data=!4m6!3m5!1s0x6ad642b1b46283b9:0x33718f02306f1e54!8m2!3d-37.8225942!4d144.9689278!16zL20vMGhoaHM?entry=ttu&g_ep=EgoyMDI1MTEyMy4xIKXMDSoASAFQAw%3D%3D
    double lat = -37.8093153;
    double lon = 144.9946003;

    public NavigationP()
    {
        InitializeComponent();
    }


    private async void MapLayer_OnSizeChanged(object sender, EventArgs e)
    {
        if (_initialized)
            return;
        _initialized = true;

        mapView.MapUnit = GeographyUnit.Meter;

        var overlay = new LayerOverlay { TileHeight = MapConfig.TileSize, TileWidth = MapConfig.TileSize, ZoomLevelSet = new GDA2020ZoomLevelSet(), TileType = TileType.SingleTile };
        mapView.Overlays.Add(overlay);
        overlay.Layers.Add(new MyMapLayer());

        InMemoryFeatureLayer featureLayer = new InMemoryFeatureLayer();

        // After adding this line, the feature is gone 
        //featureLayer.ZoomLevelSet = new GDA2020ZoomLevelSet();

        // I assume we need this?
        featureLayer.Projection = new Projection(MapConfig.ProjString);


        var blankCircleStyle = PointStyle.CreateSimpleCircleStyle(GeoColors.DarkGreen, 40, GeoColors.White);
        blankCircleStyle.DrawingLevel = DrawingLevel.LabelLevel;

        var textStyle = new TextStyle("Name", new GeoFont("sans-serif", 12, DrawingFontStyles.Bold), GeoBrushes.White)
        {
            Mask = new AreaStyle(GeoPens.Black, GeoBrushes.White),
            MaskMargin = new DrawingMargin(2, 2, 2, 2),
            YOffsetInPixel = -10
        }; 

        featureLayer.ZoomLevelSet.ZoomLevel01.DefaultPointStyle = new PointStyle(PointSymbolType.Circle, 12, GeoBrushes.Red, GeoPens.White);
        featureLayer.ZoomLevelSet.ZoomLevel01.ApplyUntilZoomLevel = ApplyUntilZoomLevel.Level20;

        // The point look wrong on the map...? is that because the projection conversion or the tile calculation?
        var point = MappingExtensions.ConvertLatLonToMeters(lat, lon);

        ThinkGeo.Core.Feature feature = new Feature(point.X, point.Y, "X");
        feature.ColumnValues.Add("Name", "Here");
        featureLayer.InternalFeatures.Add(feature);

        overlay.Layers.Add(featureLayer);

        mapView.CenterPoint = point;
        mapView.MapScale = MapConfig.MapZoomingDetails[3].Scale;

        await mapView.RefreshAsync();
    }

 


   
}