using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;

namespace BlazorWmtsDebug
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        public void ConfigureServices(IServiceCollection services)
        {
            services.AddRazorPages();
            services.AddServerSideBlazor();
        }

        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
            }

            app.Use(async (context, next) =>
            {
                if (context.Request.Path.Equals("/js/blazormap"))
                {
                    context.Request.Path = "/js/blazormap.js";
                }
                else if (context.Request.Path.Equals("/js/adornerlayer.extensions.ol"))
                {
                    context.Request.Path = "/js/adornerlayer.extensions.ol.js";
                }
                else if (context.Request.Path.Equals("/js/watermark.extensions.ol"))
                {
                    context.Request.Path = "/js/watermark.extensions.ol.js";
                }

                await next();
            });

            app.UseStaticFiles();

            app.UseRouting();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapBlazorHub();
                endpoints.MapFallbackToPage("/_Host");
            });
        }
    }
}
