﻿Imports ThinkGeo.UI.WinForms
Imports ThinkGeo.Core
Public Class Form1
  Public WithEvents MainMap As MapView
  Private WithEvents moExtentOverlay As ExtentInteractiveOverlay
  Private moShapefile As CustomShapefile
  Private moSelectionLayer As New InMemoryFeatureLayer
  Private moPageLayoutStuff As CreatePageLayout
  Private WithEvents moTrackOverlay As TrackInteractiveOverlay
  Private WithEvents moEditOverlay As CustomEditOverlay
  Private WithEvents moExistingControlPointsLayer As InMemoryFeatureLayer
  Public Const csBingMapsKey = "BingMapsKey"
  Public Sub New()
    InitializeComponent()
  End Sub
  Private Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
    MainMap = New MapView With {
      .Dock = DockStyle.Fill
    }
    Controls.Add(MainMap)
    MainMap.BringToFront()

    MainMap.MapUnit = GeographyUnit.Meter
    MainMap.ExtentOverlay.PanMode = MapPanMode.StandardPanning

    ZoomLevelHelper.InitZoomLevels()
    ZoomLevelHelper.ApplyCustomZoomLevels(MainMap.ZoomLevelSet, ZoomLevelHelper.EnumSymbolType.None)
    btnProj.Text = "Set Projection"
    mAddShapefile()
    mAddWmsLayer()

  End Sub

  Private WithEvents moWmsAsyncLayer As WmsAsyncLayer
  Private Async Sub mAddWmsLayer()
    moWmsAsyncLayer = New WmsAsyncLayer(New Uri("https://sdmdataaccess.sc.egov.usda.gov/Spatial/SDM.wms"))
    'Dim oCrs = oWmsAsyncLayer.GetServerCrsCollection

    moWmsAsyncLayer.Crs = "EPSG:3857"
    moWmsAsyncLayer.UserAgent = "WildBird"
    moWmsAsyncLayer.AxisOrder = WmsAxisOrder.Default
    moWmsAsyncLayer.DrawingExceptionMode = DrawingExceptionMode.DrawException
    moWmsAsyncLayer.IsTransparent = True
    moWmsAsyncLayer.OutputFormat = "image/png"

    '
    moWmsAsyncLayer.ActiveLayerNames.Add("surveyareapolytransparent")
    moWmsAsyncLayer.ActiveLayerNames.Add("surveyareapolyoutline")


    Dim sExternalParams As String = Projection.GetProjStringByEsriSrid(102003)
    Dim sInternalParams As String = Projection.GetProjStringByEpsgSrid(3857)
    Dim oProjConverter As New GdalProjectionConverter(sInternalParams, sExternalParams)
    'moWmsAsyncLayer.ProjectionConverter = oProjConverter

    Dim oOverlay As LayerOverlay = CType(MainMap.Overlays("Layers"), LayerOverlay)
    oOverlay.Layers.Add(moWmsAsyncLayer)
    oOverlay.Layers.MoveToBottom(moWmsAsyncLayer)
    moWmsAsyncLayer.ActiveStyleNames.Add("default")

    Await moWmsAsyncLayer.OpenAsync
    'Dim o = moWmsAsyncLayer.GetServerStyleNames
    'Dim x = moWmsAsyncLayer.GetBoundingBox
    'Dim s = moWmsAsyncLayer.GetServiceVersion

    'MainMap.Overlays.Add("Layers", oOverlay)
    'Dim oProjConverter2 = New ProjectionConverter(3857, 102003)
    'oProjConverter.Open()
    'MainMap.CurrentExtent = CType(oProjConverter.ConvertToExternalProjection(New RectangleShape(-10089827.8294119, 4041168.72636359, -8142823.8557486, 2615508.96101069)), RectangleShape)

    Await MainMap.RefreshAsync
  End Sub
  Private Async Sub mAddShapefile()
    moShapefile = New CustomShapefile("..\..\Data\States_Albers.shp")
    Dim oAreaStyle1 As AreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColors.Transparent, GeoColors.Blue, 1)
    Dim oAreaStyle2 As AreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColors.Transparent, GeoColors.Red, 1)
    ZoomLevelHelper.ApplyCustomZoomLevels(moShapefile.ZoomLevelSet, ZoomLevelHelper.EnumSymbolType.AreaSymbol)
    ZoomLevelHelper.ApplyCustomZoomLevels(moSelectionLayer.ZoomLevelSet, ZoomLevelHelper.EnumSymbolType.AreaSymbol)

    Dim iFirstHalf As Integer = 20
    Dim iSecondHalf = 38
    Dim iCounter As Integer = 0

    For Each oZoomLevel As ZoomLevel In moShapefile.ZoomLevelSet.CustomZoomLevels
      If iCounter < 20 Then
        oZoomLevel.DefaultAreaStyle = oAreaStyle1
      Else
        oZoomLevel.DefaultAreaStyle = oAreaStyle2
        'oZoomLevel.DefaultAreaStyle = Nothing
      End If
      iCounter = iCounter + 1
    Next oZoomLevel
    moShapefile.DrawingQuality = DrawingQuality.HighSpeed
    Dim oProj As New ProjectionConverter(102003, 3857)
    moShapefile.FeatureSource.ProjectionConverter = oProj

    Dim oSelectionStyle As AreaStyle = AreaStyle.CreateSimpleAreaStyle(GeoColors.LightGray, GeoColors.DimGray, 3)
    For Each oZoomLevel As ZoomLevel In moSelectionLayer.ZoomLevelSet.CustomZoomLevels
      oZoomLevel.DefaultAreaStyle = oSelectionStyle
    Next oZoomLevel

    moShapefile.SelectionLayer = moSelectionLayer


    Dim oOverlay As New LayerOverlay() With {.Name = "Layers"}
    MainMap.Overlays.Add("Layers", oOverlay)
    oOverlay.Layers.Add(moShapefile)
    oProj.Open()
    'MainMap.CurrentExtent = oProj.ConvertToExternalProjection(New RectangleShape(-9762065.08512668, 3744836.02203581, -9681550.03146195, 3697034.6992771))
    MainMap.CurrentExtent = New RectangleShape(-9762065.08512668, 3744836.02203581, -9681550.03146195, 3697034.6992771)
    'Await MainMap.RefreshAsync
  End Sub
  Private Sub MainMap_CurrentExtentChanged(sender As Object, e As CurrentExtentChangedMapViewEventArgs) Handles MainMap.CurrentExtentChanged
    Dim o = MainMap.CurrentExtent
  End Sub
  Private Async Sub mAddRemoveProjectionFromWmsLayer(bRemove As Boolean)
    If bRemove Then
      moWmsAsyncLayer.ProjectionConverter = Nothing
      Dim oProjConverter As New ProjectionConverter(102003, 3857)
      moShapefile.FeatureSource.ProjectionConverter = oProjConverter
      oProjConverter.Open()
      MainMap.CurrentExtent = New RectangleShape(-9762065.08512668, 3744836.02203581, -9681550.03146195, 3697034.6992771)
    Else
      moShapefile.FeatureSource.ProjectionConverter = Nothing
      Dim sExternalParams As String = Projection.GetProjStringByEsriSrid(102003)
      Dim sInternalParams As String = Projection.GetProjStringByEpsgSrid(3857)
      Dim oProjConverter As New GdalProjectionConverter(sInternalParams, sExternalParams)
      oProjConverter.Open()
      moWmsAsyncLayer.ProjectionConverter = oProjConverter
      MainMap.CurrentExtent = CType(oProjConverter.ConvertToExternalProjection(New RectangleShape(-10089827.8294119, 4041168.72636359, -8142823.8557486, 2615508.96101069)), RectangleShape)
    End If

    Await MainMap.RefreshAsync

  End Sub

  Private Sub moWmsAsyncLayer_SendingHttpRequest(sender As Object, e As SendingHttpRequestMessageEventArgs) Handles moWmsAsyncLayer.SendingHttpRequest
    Debug.WriteLine(e.HttpRequestMessage)
  End Sub

  Private Sub btnProj_Click(sender As Object, e As EventArgs) Handles btnProj.Click
    Dim bRemove As Boolean
    If btnProj.Text = "Set Projection" Then
      btnProj.Text = "RemoveProjection"
      bRemove = False
    Else
      btnProj.Text = "Set Projection"
      bRemove = True
    End If
    mAddRemoveProjectionFromWmsLayer(bRemove)
  End Sub

End Class
